@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Tambah Hasil Pemeriksaan</h1>
                    <p class="text-gray-600 mt-1">Upload hasil pemeriksaan pasien ke sistem</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.exam-results.index') }}" 
                       class="bg-[#8B8B8B] text-white px-4 py-2 rounded-none hover:bg-[#192D50] transition duration-150">
                        Kembali
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">

            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                <div class="p-6 text-gray-900">
                    <form method="POST" action="{{ route('admin.exam-results.store') }}" enctype="multipart/form-data" class="space-y-6">
                        @csrf
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <x-input-label for="patient_id" :value="__('Pasien')" />
                                <select id="patient_id" name="patient_id" class="block mt-1 w-full border-gray-300 focus:border-[#CBB4B0] focus:ring-[#CBB4B0] rounded-none shadow-sm">
                                    <option value="">Pilih Pasien</option>
                                    @foreach($patients as $patient)
                                        <option value="{{ $patient->id }}" {{ old('patient_id') == $patient->id ? 'selected' : '' }}>
                                            {{ $patient->name }} ({{ $patient->email }})
                                        </option>
                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('patient_id')" class="mt-2" />
                            </div>

                            <div>
                                <x-input-label for="employee_id" :value="__('Karyawan')" />
                                <select id="employee_id" name="employee_id" class="block mt-1 w-full border-gray-300 focus:border-[#CBB4B0] focus:ring-[#CBB4B0] rounded-none shadow-sm">
                                    <option value="">Pilih Karyawan</option>
                                    @foreach($employees as $employee)
                                        <option value="{{ $employee->id }}" {{ old('employee_id') == $employee->id ? 'selected' : '' }}>
                                            {{ $employee->name }} - {{ $employee->company->name ?? 'N/A' }} ({{ $employee->employee_number }})
                                        </option>
                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('employee_id')" class="mt-2" />
                            </div>

                            <div>
                                <x-input-label for="partner_id" :value="__('Rekanan')" />
                                <select id="partner_id" name="partner_id" class="block mt-1 w-full border-gray-300 focus:border-[#CBB4B0] focus:ring-[#CBB4B0] rounded-none shadow-sm">
                                    <option value="">Pilih Rekanan</option>
                                    @foreach($partners as $partner)
                                        <option value="{{ $partner->id }}" {{ old('partner_id') == $partner->id ? 'selected' : '' }}>
                                            {{ $partner->name }} ({{ $partner->code }})
                                        </option>
                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('partner_id')" class="mt-2" />
                            </div>

                            <div>
                                <x-input-label for="exam_type" :value="__('Jenis Pemeriksaan')" />
                                <select id="exam_type" name="exam_type" class="block mt-1 w-full border-gray-300 focus:border-[#CBB4B0] focus:ring-[#CBB4B0] rounded-none shadow-sm" required>
                                    <option value="">Pilih Jenis Pemeriksaan</option>
                                    <option value="MCU" {{ old('exam_type') == 'MCU' ? 'selected' : '' }}>Medical Check Up</option>
                                    <option value="Laboratorium" {{ old('exam_type') == 'Laboratorium' ? 'selected' : '' }}>Pemeriksaan Laboratorium</option>
                                    <option value="Radiologi" {{ old('exam_type') == 'Radiologi' ? 'selected' : '' }}>Pemeriksaan Radiologi</option>
                                    <option value="Lainnya" {{ old('exam_type') == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                </select>
                                <x-input-error :messages="$errors->get('exam_type')" class="mt-2" />
                            </div>
                        </div>

                        <div class="bg-blue-50 border border-blue-200 rounded-none p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-blue-400" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <h3 class="text-sm font-medium text-blue-800">
                                        Informasi Penting
                                    </h3>
                                    <div class="mt-2 text-sm text-blue-700">
                                        <p>Pilih minimal satu dari: <strong>Pasien</strong>, <strong>Karyawan</strong>, atau <strong>Rekanan</strong> untuk hasil pemeriksaan ini.</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <x-input-label for="exam_date" :value="__('Tanggal Pemeriksaan')" />
                                <x-text-input id="exam_date" class="block mt-1 w-full" type="date" name="exam_date" :value="old('exam_date')" required />
                                <x-input-error :messages="$errors->get('exam_date')" class="mt-2" />
                            </div>
                        </div>

                        <div>
                            <x-input-label for="result_file" :value="__('File Hasil Pemeriksaan')" />
                            <input id="result_file" class="block mt-1 w-full" type="file" name="result_file" accept=".pdf,.doc,.docx" required />
                            <p class="mt-1 text-sm text-gray-500">Format: PDF, DOC, DOCX (Max: 10MB)</p>
                            <x-input-error :messages="$errors->get('result_file')" class="mt-2" />
                        </div>

                        <div>
                            <x-input-label for="notes" :value="__('Catatan')" />
                            <textarea id="notes" name="notes" rows="3" class="block mt-1 w-full border-gray-300 focus:border-[#CBB4B0] focus:ring-[#CBB4B0] rounded-none shadow-sm">{{ old('notes') }}</textarea>
                            <x-input-error :messages="$errors->get('notes')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end">
                            <a href="{{ route('admin.exam-results.index') }}" 
                               class="mr-4 inline-flex items-center px-4 py-2 bg-[#8B8B8B] border border-transparent rounded-none font-semibold text-xs text-white uppercase tracking-widest hover:bg-[#192D50] focus:bg-[#192D50] active:bg-[#8B8B8B] focus:outline-none focus:ring-2 focus:ring-[#CBB4B0] focus:ring-offset-2 transition ease-in-out duration-150">
                                Batal
                            </a>
                            <x-primary-button>
                                {{ __('Simpan') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('form');
    const patientSelect = document.getElementById('patient_id');
    const employeeSelect = document.getElementById('employee_id');
    const partnerSelect = document.getElementById('partner_id');
    
    form.addEventListener('submit', function(e) {
        const patientValue = patientSelect.value;
        const employeeValue = employeeSelect.value;
        const partnerValue = partnerSelect.value;
        
        if (!patientValue && !employeeValue && !partnerValue) {
            e.preventDefault();
            alert('Pilih minimal satu dari: Pasien, Karyawan, atau Rekanan.');
            return false;
        }
    });
    
    // Optional: Clear other selections when one is selected
    patientSelect.addEventListener('change', function() {
        if (this.value) {
            employeeSelect.value = '';
            partnerSelect.value = '';
        }
    });
    
    employeeSelect.addEventListener('change', function() {
        if (this.value) {
            patientSelect.value = '';
            partnerSelect.value = '';
        }
    });
    
    partnerSelect.addEventListener('change', function() {
        if (this.value) {
            patientSelect.value = '';
            employeeSelect.value = '';
        }
    });
});
</script>
